from PIL import Image, ExifTags


def extraire_exif(nom_fichier):
    """
    Renvoie les métadonnées EXIF du fichier << nom_fichier >>

    Paramètre :
    nom_fichier - chaîne de caractères du chemin vers un fichier image

    Retour :
    Renvoie un dictionnaire des métadonnées EXIF
    """
    image = Image.open(nom_fichier)
    donnees_exif = image._getexif()
    donnees_exif_tag = {}

    if donnees_exif is not None:
        for cle, valeur in donnees_exif.items():
            if cle in ExifTags.TAGS:
                if ExifTags.TAGS[cle] in ["MakerNote"]:
                    continue
                donnees_exif_tag[ExifTags.TAGS[cle]] = valeur

    return donnees_exif_tag