#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import csv # import du module

def csv_vers_table(chemin):
    """
    Extrait le contenu d'un fichier csv dans un table

    Paramètre:
        chemin (str): chemin vers le fichier csv
    
    Retour:
        tableau de dictionnaires 
        dont les clefs sont les attributs de la table 
        (titres des colonnes en première ligne du fichier csv)        
    """
    f = open(chemin, mode='r', encoding='utf8', newline='')
    reader = csv.DictReader(f, delimiter=',') 
    table = [dict(enregistrement) for enregistrement in reader]
    f.close()
    return table

#%%
def incrementation_binaire(tableau_bits):
    """
    Renvoie la représentation binaire
    du successeur de l'entier représenté
    en binaire par tableau_bits
    (sur le même nombre de bits)

    Parametre:
        tableau_bits : tableau de bits (0 ou 1)

    Returns:
        tableau de bits (O ou 1) de même taille que tableau_bits
    """
    # copie superficielle de tableau_bits
    copie = tableau_bits[:]
    # à compléter

def test_incrementation_binaire():
    """
    Tests unitaires pour incrementation_binaire
    """
    assert incrementation_binaire([0, 0]) == [0, 1]
    assert incrementation_binaire([0, 1]) == [1, 0]
    assert incrementation_binaire([1, 0]) == [1, 1]
    assert incrementation_binaire([0, 1, 1]) == [1, 0, 0]
    print("Tests réussis")

def liste_parties(n):
    """
    Renvoie la liste des parties 
    d'un ensemble à n éléments codées en binaire
    
    Parametre:
        n (int) : taille de l'ensemble
    
    Retour:
        Tableau de tableaux de bits de taille n    
    """    
    dernier = [0] * n
    liste = [dernier]
    for k in range(2 ** n - 1):
        "à compléter"
    return liste

def test_liste_parties():
    """
    Tests unitaires pour liste_parties
    """
    assert liste_parties(1) == [[0], [1]]
    assert liste_parties(2) == [[0, 0], [0, 1], [1, 0], [1, 1]]
    assert liste_parties(3) == [[0, 0, 0], [0, 0, 1], [0, 1, 0],
                                [0, 1, 1], [1, 0, 0], [1, 0, 1],
                                [1, 1, 0], [1, 1, 1]]
    print("Tests réussis")

def somme_tab(t):
    """
    Renvoie la somme des éléments d'un tableau de nombres

    Parameters:
        t : tableau de nombres
    
    Returns:
        un nombre
    """
    s = 0
    # à compléter

def sac_force_brute(table, masse_max):
    """
    Renvoie une valeur maximale
    et une sélection d'objets la réalisant
    pour une contrainte de masse masse_max
    et une table d'objets  


    Parameters:
        table : tableau de dictionnaires 
                d'attributs ('objet', 'valeur', 'masse')
        masse_max (int): masse maximale du sac

    Returns:
        tuple :
            valeur_max (int)
            selection_max (tableau de dictionnaires)        
    """
    n = len(table)
    parties = liste_parties(n)
    selection_max =  [objet for objet in table if float(objet['masse']) <= masse_max][0]
    valeur_max =  float(selection_max['valeur'])    
    for p in parties:
        selection = [table[k] for k in range(n) if p[k] == 1]
        # à compléter    
    return valeur_max, selection_max

def test_sac_force_brute():
    """
    Tests unitaires
    pour sac_force_brute
    """
    sac1 = csv_vers_table('sac1.csv')
    assert sac_force_brute(sac1, 20) == (11.0,
 [{'objet': '1', 'valeur': '2', 'masse': '10'},
  {'objet': '3', 'valeur': '4', 'masse': '7'},
  {'objet': '4', 'valeur': '5', 'masse': '3'}])
    sac2 = csv_vers_table('sac2.csv')
    assert sac_force_brute(sac2, 40) == (37.0,
 [{'objet': '3', 'valeur': '8', 'masse': '7'},
  {'objet': '5', 'valeur': '8', 'masse': '6'},
  {'objet': '6', 'valeur': '10', 'masse': '15'},
  {'objet': '7', 'valeur': '11', 'masse': '8'}])
    print("Tests réussis")
        
#%%

def sac_glouton(table, masse_max):
    """
    Renvoie une valeur totale de sac
    et une sélection d'objets remplissant le sac
    Sélection gloutonne des objets dans l'ordre 
    de parcours de table en choisissant 
    l'objet courant s'il peut s'ajouter au sac

    Parameters:
        table : tableau de dictionnaires 
                d'attributs ('objet', 'valeur', 'masse')
        masse_max (int): masse maximale du sac

    Returns:
        tuple :
            valeur_max (int)
            selection_max (tableau de dictionnaires)        
    """
    i = 0
    total_masse = 0
    total_valeur = 0
    n = len(table)
    selection = []
    # à compléter
    return total_valeur, selection

#%%
def clef_tri_masse_croissant(objet):
    return float(objet['masse'])

def clef_tri_valeur_decroissant(objet):
    return -float(objet['valeur'])

def clef_tri_ratio_decroissant(objet):
    return  -float(objet['valeur']) / float(objet['masse'])

#%%
def test_sac_glouton():
    """
    tests unitaires pour sac_glouton
    """
    # à compléter
    print("Tests réussis")




